/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class GeneralParametersWithIV<T extends GeneralParameters>
extends GeneralParameters<GeneralAlgorithm>
implements ParametersWithIV<T> {
    protected final int blockSize;
    protected final byte[] iv;

    GeneralParametersWithIV(GeneralAlgorithm generalAlgorithm, int n, byte[] byArray) {
        super(generalAlgorithm);
        this.blockSize = n;
        this.iv = byArray;
    }

    @Override
    public byte[] getIV() {
        return Arrays.clone(this.iv);
    }

    @Override
    public T withIV(SecureRandom secureRandom) {
        if (((GeneralAlgorithm)this.getAlgorithm()).getName().indexOf("GCM") >= 0) {
            return this.create((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(12, secureRandom));
        }
        return this.create((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(this.blockSize, secureRandom));
    }

    @Override
    public T withIV(byte[] byArray) {
        return this.create((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(byArray));
    }

    abstract T create(GeneralAlgorithm var1, byte[] var2);
}

