/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.RangesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \u0014*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0002\u0013\u0014B%\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ0\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0000\"\u000e\b\u0001\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000e0\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/util/Range;", "T", "", "", "leftBound", "Lorg/jetbrains/plugins/gradle/util/Range$Bound;", "rightBound", "<init>", "(Lorg/jetbrains/plugins/gradle/util/Range$Bound;Lorg/jetbrains/plugins/gradle/util/Range$Bound;)V", "contains", "", "value", "(Ljava/lang/Comparable;)Z", "map", "R", "transform", "Lkotlin/Function1;", "toString", "", "Bound", "Companion", "intellij.gradle"})
final class Range<T extends Comparable<? super T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bound<T> leftBound;
    @NotNull
    private final Bound<T> rightBound;

    private Range(Bound<? extends T> leftBound, Bound<? extends T> rightBound) {
        this.leftBound = leftBound;
        this.rightBound = rightBound;
    }

    public final boolean contains(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!Intrinsics.areEqual(this.leftBound, (Object)Bound.Inf.INSTANCE) && ((Comparable)this.leftBound.getValue()).compareTo(value) == 0) {
            return this.leftBound.isInclusive();
        }
        if (!Intrinsics.areEqual(this.rightBound, (Object)Bound.Inf.INSTANCE) && ((Comparable)this.rightBound.getValue()).compareTo(value) == 0) {
            return this.rightBound.isInclusive();
        }
        return !(!Intrinsics.areEqual(this.leftBound, (Object)Bound.Inf.INSTANCE) && ((Comparable)this.leftBound.getValue()).compareTo(value) >= 0 || !Intrinsics.areEqual(this.rightBound, (Object)Bound.Inf.INSTANCE) && value.compareTo(this.rightBound.getValue()) >= 0);
    }

    @NotNull
    public final <R extends Comparable<? super R>> Range<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return new Range<R>(this.leftBound.map(transform), this.rightBound.map(transform));
    }

    @NotNull
    public String toString() {
        String leftBracket = this.leftBound.isInclusive() ? "[" : "(";
        String rightBracket = this.rightBound.isInclusive() ? "]" : ")";
        String leftValue = Intrinsics.areEqual(this.leftBound, (Object)Bound.Inf.INSTANCE) ? "-\u221e" : this.leftBound.getValue().toString();
        String rightValue = Intrinsics.areEqual(this.rightBound, (Object)Bound.Inf.INSTANCE) ? "\u221e" : this.rightBound.getValue().toString();
        return leftBracket + leftValue + "," + rightValue + rightBracket;
    }

    public /* synthetic */ Range(Bound leftBound, Bound rightBound, DefaultConstructorMarker $constructor_marker) {
        this(leftBound, rightBound);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002:\u0002\r\u000eJ(\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0000\"\u0004\b\u0002\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\n0\fH&R\u0012\u0010\u0003\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u0082\u0001\u0002\u000f\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gradle/util/Range$Bound;", "T", "", "value", "getValue", "()Ljava/lang/Object;", "isInclusive", "", "()Z", "map", "R", "transform", "Lkotlin/Function1;", "Impl", "Inf", "Lorg/jetbrains/plugins/gradle/util/Range$Bound$Impl;", "Lorg/jetbrains/plugins/gradle/util/Range$Bound$Inf;", "intellij.gradle"})
    private static sealed interface Bound<T> {
        public T getValue();

        public boolean isInclusive();

        @NotNull
        public <R> Bound<R> map(@NotNull Function1<? super T, ? extends R> var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0000\"\u0004\b\u0003\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u0002H\r0\u000fH\u0016R\u0016\u0010\u0003\u001a\u00028\u0002X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/util/Range$Bound$Impl;", "T", "Lorg/jetbrains/plugins/gradle/util/Range$Bound;", "value", "isInclusive", "", "<init>", "(Ljava/lang/Object;Z)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "()Z", "map", "R", "transform", "Lkotlin/Function1;", "intellij.gradle"})
        public static final class Impl<T>
        implements Bound<T> {
            private final T value;
            private final boolean isInclusive;

            public Impl(T value, boolean isInclusive) {
                this.value = value;
                this.isInclusive = isInclusive;
            }

            @Override
            public T getValue() {
                return this.value;
            }

            @Override
            public boolean isInclusive() {
                return this.isInclusive;
            }

            @Override
            @NotNull
            public <R> Impl<R> map(@NotNull Function1<? super T, ? extends R> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return new Impl<Object>(transform.invoke(this.getValue()), this.isInclusive());
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u000b\u001a\u00020\u0000\"\u0004\b\u0002\u0010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\f0\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/util/Range$Bound$Inf;", "Lorg/jetbrains/plugins/gradle/util/Range$Bound;", "", "<init>", "()V", "value", "getValue", "()Ljava/lang/Void;", "isInclusive", "", "()Z", "map", "R", "transform", "Lkotlin/Function1;", "intellij.gradle"})
        public static final class Inf
        implements Bound {
            @NotNull
            public static final Inf INSTANCE = new Inf();
            private static final boolean isInclusive;

            private Inf() {
            }

            @NotNull
            public Void getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInclusive() {
                return isInclusive;
            }

            @NotNull
            public <R> Inf map(@NotNull Function1<?, ? extends R> transform) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                return INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u000e\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\b\u0010\b\u001a\u0004\u0018\u0001H\u00062\b\u0010\t\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/util/Range$Companion;", "", "<init>", "()V", "valueOf", "Lorg/jetbrains/plugins/gradle/util/Range;", "T", "", "from", "to", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)Lorg/jetbrains/plugins/gradle/util/Range;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends Comparable<? super T>> Range<T> valueOf(@Nullable T from, @Nullable T to) {
            Bound leftBound = Intrinsics.areEqual(from, (Object)RangesKt.getINF()) ? (Bound)Bound.Inf.INSTANCE : (Bound)new Bound.Impl<T>(from, true);
            Bound rightBound = Intrinsics.areEqual(to, (Object)RangesKt.getINF()) ? (Bound)Bound.Inf.INSTANCE : (Bound)new Bound.Impl<T>(to, false);
            return new Range(leftBound, rightBound, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

