/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.informix;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class InformixUtils {
    static final Log log = Log.getLog(InformixUtils.class);

    /*
     * Loose catch block
     */
    public static List<String> getSource(DBRProgressMonitor monitor, String sqlStatement, String dbObjectName, GenericDataSource datasource) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)datasource, (String)"Load source code");){
                ArrayList<String> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block33: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbStat = session.prepareStatement(sqlStatement);
                    ArrayList<String> result = new ArrayList<String>();
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        boolean firstPart = true;
                        while (dbResult.nextRow()) {
                            Object procBodyPart = dbResult.getString(1);
                            if (((String)procBodyPart).startsWith("create") && !firstPart) {
                                procBodyPart = "\n" + (String)procBodyPart;
                            }
                            firstPart = false;
                            result.add((String)procBodyPart);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block33;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("Can't read source code of '" + dbObjectName + "'", (Throwable)e);
        }
    }

    public static String listToString(List<String> value, String delimiter) {
        StringBuilder sbResult = new StringBuilder();
        for (String o : value) {
            sbResult.append(o);
            if (delimiter == null || delimiter.isEmpty()) continue;
            sbResult.append(delimiter);
        }
        return sbResult.toString();
    }

    public static String getProcedureSource(DBRProgressMonitor monitor, GenericProcedure procedure) throws DBException {
        String sqlProcedure = String.format("select b.data from sysprocbody b join sysprocedures p on b.procid=p.procid where datakey='T' and p.procname = '%s'order by b.procid, b.seqno", procedure.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlProcedure, procedure.getName(), (GenericDataSource)procedure.getDataSource()), null);
    }

    public static String getViewSource(DBRProgressMonitor monitor, GenericTableBase view) throws DBException {
        String sqlView = String.format("select v.viewtext from informix.sysviews v join systables s on s.tabid = v.tabid where s.tabname = '%s'", view.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlView, view.getName(), (GenericDataSource)view.getDataSource()), null);
    }

    public static String getTriggerDDL(DBRProgressMonitor monitor, GenericTableBase table) throws DBException {
        String sqlTrigger = String.format("select tb.data from systables ta join systriggers tr on tr.tabid = ta.tabid join systrigbody tb on tb.trigid = tr.trigid where ta.tabname = '%s' and ta.tabtype='T' and tb.datakey IN ('A', 'D') order by tr.trigname, datakey desc, seqno ", table.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlTrigger, table.getName(), (GenericDataSource)table.getDataSource()), "\n");
    }

    public static String getTriggerDDL(DBRProgressMonitor monitor, GenericTrigger trigger) throws DBException {
        assert (trigger.getTable() != null);
        String sqlTrigger = String.format("select tb.data from systables ta join systriggers tr on tr.tabid = ta.tabid join systrigbody tb on tb.trigid = tr.trigid where ta.tabname = '%s' and ta.tabtype='T' and tb.datakey IN ('A', 'D') and tr.trigname = '%s'order by tr.trigname, datakey desc, seqno ", trigger.getTable().getName(), trigger.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlTrigger, trigger.getName(), trigger.getDataSource()), "\n");
    }
}

