// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!
#ifndef _GSKMM_ENUMS_H
#define _GSKMM_ENUMS_H

#include <gskmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2025 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/value.h>
#include <gsk/gsk.h>


namespace Gsk
{
/** @addtogroup gskmmEnums gskmm Enums and Flags */

/** 
 *  @var BlendMode::DEFAULT
 * The default blend mode, which specifies no blending.
 * 
 *  @var BlendMode::MULTIPLY
 * The source color is multiplied by the destination
 * and replaces the destination.
 * 
 *  @var BlendMode::SCREEN
 * Multiplies the complements of the destination and source
 * color values, then complements the result.
 * 
 *  @var BlendMode::OVERLAY
 * Multiplies or screens the colors, depending on the
 * destination color value. This is the inverse of hard-list.
 * 
 *  @var BlendMode::DARKEN
 * Selects the darker of the destination and source colors.
 * 
 *  @var BlendMode::LIGHTEN
 * Selects the lighter of the destination and source colors.
 * 
 *  @var BlendMode::COLOR_DODGE
 * Brightens the destination color to reflect the source color.
 * 
 *  @var BlendMode::COLOR_BURN
 * Darkens the destination color to reflect the source color.
 * 
 *  @var BlendMode::HARD_LIGHT
 * Multiplies or screens the colors, depending on the source color value.
 * 
 *  @var BlendMode::SOFT_LIGHT
 * Darkens or lightens the colors, depending on the source color value.
 * 
 *  @var BlendMode::DIFFERENCE
 * Subtracts the darker of the two constituent colors from the lighter color.
 * 
 *  @var BlendMode::EXCLUSION
 * Produces an effect similar to that of the difference mode but lower in contrast.
 * 
 *  @var BlendMode::COLOR
 * Creates a color with the hue and saturation of the source color and the luminosity of the destination color.
 * 
 *  @var BlendMode::HUE
 * Creates a color with the hue of the source color and the saturation and luminosity of the destination color.
 * 
 *  @var BlendMode::SATURATION
 * Creates a color with the saturation of the source color and the hue and luminosity of the destination color.
 * 
 *  @var BlendMode::LUMINOSITY
 * Creates a color with the luminosity of the source color and the hue and saturation of the destination color.
 */
 /** The blend modes available for render nodes.
 * 
 * The implementation of each blend mode is deferred to the
 * rendering pipeline.
 * 
 * See <https://www.w3.org/TR/compositing-1/#blending> for more information
 * on blending and blend modes.
 * 
 * @newin{4,20}
 *
 * @ingroup gskmmEnums
 */
enum class BlendMode
{
  DEFAULT,
  MULTIPLY,
  SCREEN,
  OVERLAY,
  DARKEN,
  LIGHTEN,
  COLOR_DODGE,
  COLOR_BURN,
  HARD_LIGHT,
  SOFT_LIGHT,
  DIFFERENCE,
  EXCLUSION,
  COLOR,
  HUE,
  SATURATION,
  LUMINOSITY
};


} // namespace Gsk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GSKMM_API Value<Gsk::BlendMode> : public Glib::Value_Enum<Gsk::BlendMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsk
{

/** 
 *
 * @ingroup gskmmEnums
 */
enum class PorterDuff
{
  SOURCE,
  DEST,
  SOURCE_OVER_DEST,
  DEST_OVER_SOURCE,
  SOURCE_IN_DEST,
  DEST_IN_SOURCE,
  SOURCE_OUT_DEST,
  DEST_OUT_SOURCE,
  SOURCE_ATOP_DEST,
  DEST_ATOP_SOURCE,
  XOR,
  CLEAR
};


} // namespace Gsk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GSKMM_API Value<Gsk::PorterDuff> : public Glib::Value_Enum<Gsk::PorterDuff>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsk
{

/** Wrapper for enum Corner.
 * Corner enumerators are scoped and can be implicitly converted to int.
 * The scope is Gsk::Corner::
 *
 * @ingroup gskmmEnums
 */
class Corner_Wrapper final
{
public:
  /** 
   *  @var Corner TOP_LEFT
   * The top left corner.
   * 
   *  @var Corner TOP_RIGHT
   * The top right corner.
   * 
   *  @var Corner BOTTOM_RIGHT
   * The bottom right corner.
   * 
   *  @var Corner BOTTOM_LEFT
   * The bottom left corner.
   */
   /** The corner indices used by `Gsk::RoundedRect`.
   * 
   * @newin{4,20}
   *
   * @ingroup gskmmEnums
   */
  enum Corner
  {
    TOP_LEFT,
    TOP_RIGHT,
    BOTTOM_RIGHT,
    BOTTOM_LEFT
  };
  #ifndef DOXYGEN_SHOULD_SKIP_THIS
  Corner_Wrapper() = delete;
  #endif
};
/** Corner enumerators are scoped by the wrapper class
 * and can be implicitly converted to int.
 *
 * @ingroup gskmmEnums
 */
using Corner = Corner_Wrapper::Corner;


} // namespace Gsk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GSKMM_API Value<Gsk::Corner> : public Glib::Value_Enum<Gsk::Corner>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsk
{

/** 
 *  @var FillRule::WINDING
 * If the path crosses the ray from
 * left-to-right, counts +1. If the path crosses the ray
 * from right to left, counts -1. (Left and right are determined
 * from the perspective of looking along the ray from the starting
 * point.) If the total count is non-zero, the point will be filled.
 * 
 *  @var FillRule::EVEN_ODD
 * Counts the total number of
 * intersections, without regard to the orientation of the contour. If
 * the total number of intersections is odd, the point will be
 * filled.
 */
 /** Specifies how paths are filled.
 * 
 * Whether or not a point is included in the fill is determined by taking
 * a ray from that point to infinity and looking at intersections with the
 * path. The ray can be in any direction, as long as it doesn't pass through
 * the end point of a segment or have a tricky intersection such as
 * intersecting tangent to the path.
 * 
 * (Note that filling is not actually implemented in this way. This
 * is just a description of the rule that is applied.)
 * 
 * New entries may be added in future versions.
 * 
 * @newin{4,20}
 *
 * @ingroup gskmmEnums
 */
enum class FillRule
{
  WINDING,
  EVEN_ODD
};


} // namespace Gsk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GSKMM_API Value<Gsk::FillRule> : public Glib::Value_Enum<Gsk::FillRule>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsk
{

/** 
 *  @var Isolation::NONE
 * No isolation is defined.
 * 
 *  @var Isolation::BACKGROUND
 * If the background should be made available.
 * If the background is not available, future operations will be rendered
 * to a transparent background and added to the existing background later.
 * 
 *  @var Isolation::COPY_PASTE
 * If copies should be available to paste nodes.
 * If copies are not available, paste nodes can only paste from copies that
 * are made inside the isolated contents.
 * 
 *  @var Isolation::ALL
 * Isolate everything. This will include features that
 * are added in the future.
 */
 /** These flags describe the types of isolations possible with a
 * Gsk::IsolationNode.
 * 
 * More isolation options may be added in the future.
 * 
 * @newin{4,22}
 *
 * @ingroup gskmmEnums
 * @par Bitwise operators:
 * <tt>Isolation operator|(Isolation, Isolation)</tt><br>
 * <tt>Isolation operator&(Isolation, Isolation)</tt><br>
 * <tt>Isolation operator^(Isolation, Isolation)</tt><br>
 * <tt>Isolation operator~(Isolation)</tt><br>
 * <tt>Isolation& operator|=(Isolation&, Isolation)</tt><br>
 * <tt>Isolation& operator&=(Isolation&, Isolation)</tt><br>
 * <tt>Isolation& operator^=(Isolation&, Isolation)</tt><br>
 */
enum class Isolation
{
  NONE = 0x0,
  BACKGROUND = 1 << 0,
  COPY_PASTE = 1 << 1,
  ALL = -0x1
};

/** @ingroup gskmmEnums */
inline Isolation operator|(Isolation lhs, Isolation rhs)
  { return static_cast<Isolation>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gskmmEnums */
inline Isolation operator&(Isolation lhs, Isolation rhs)
  { return static_cast<Isolation>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gskmmEnums */
inline Isolation operator^(Isolation lhs, Isolation rhs)
  { return static_cast<Isolation>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gskmmEnums */
inline Isolation operator~(Isolation flags)
  { return static_cast<Isolation>(~static_cast<unsigned>(flags)); }

/** @ingroup gskmmEnums */
inline Isolation& operator|=(Isolation& lhs, Isolation rhs)
  { return (lhs = static_cast<Isolation>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gskmmEnums */
inline Isolation& operator&=(Isolation& lhs, Isolation rhs)
  { return (lhs = static_cast<Isolation>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gskmmEnums */
inline Isolation& operator^=(Isolation& lhs, Isolation rhs)
  { return (lhs = static_cast<Isolation>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gsk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GSKMM_API Value<Gsk::Isolation> : public Glib::Value_Flags<Gsk::Isolation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsk
{

/** 
 *  @var MaskMode::ALPHA
 * Use the alpha channel of the mask.
 * 
 *  @var MaskMode::INVERTED_ALPHA
 * Use the inverted alpha channel of the mask.
 * 
 *  @var MaskMode::LUMINANCE
 * Use the luminance of the mask,
 * multiplied by mask alpha.
 * 
 *  @var MaskMode::INVERTED_LUMINANCE
 * Use the inverted luminance of the mask,
 * multiplied by mask alpha.
 */
 /** The mask modes available for mask nodes.
 * 
 * @newin{4,20}
 *
 * @ingroup gskmmEnums
 */
enum class MaskMode
{
  ALPHA,
  INVERTED_ALPHA,
  LUMINANCE,
  INVERTED_LUMINANCE
};


} // namespace Gsk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GSKMM_API Value<Gsk::MaskMode> : public Glib::Value_Enum<Gsk::MaskMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsk
{

/** 
 *  @var ScalingFilter::LINEAR
 * Linear interpolation filter.
 * 
 *  @var ScalingFilter::NEAREST
 * Nearest neighbor interpolation filter.
 * 
 *  @var ScalingFilter::TRILINEAR
 * Linear interpolation along each axis,
 * plus mipmap generation, with linear interpolation along the mipmap
 * levels.
 */
 /** The filters used when scaling texture data.
 * 
 * The actual implementation of each filter is deferred to the
 * rendering pipeline.
 * 
 * @newin{4,20}
 *
 * @ingroup gskmmEnums
 */
enum class ScalingFilter
{
  LINEAR,
  NEAREST,
  TRILINEAR
};


} // namespace Gsk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GSKMM_API Value<Gsk::ScalingFilter> : public Glib::Value_Enum<Gsk::ScalingFilter>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsk
{


} // namespace Gsk


#endif /* _GSKMM_ENUMS_H */

