/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.documentgroup;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.documentgroup.DocumentGroupImpl;
import org.netbeans.core.windows.documentgroup.GroupsManager;
import org.netbeans.core.windows.documentgroup.ManageGroupsPanel;
import org.netbeans.core.windows.documentgroup.NewGroupPanel;
import org.netbeans.core.windows.documentgroup.PleaseWait;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class GroupsMenuAction
extends AbstractAction
implements Presenter.Menu {
    private static final JMenu menu = new JMenu(NbBundle.getMessage(GroupsMenuAction.class, (String)"Menu_DOCUMENT_GROUPS"));

    private GroupsMenuAction() {
        super(NbBundle.getMessage(GroupsMenuAction.class, (String)"Menu_DOCUMENT_GROUPS"));
    }

    public static AbstractAction create() {
        return new GroupsMenuAction();
    }

    public JMenuItem getMenuPresenter() {
        if (EventQueue.isDispatchThread()) {
            GroupsMenuAction.fillMenu(menu);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GroupsMenuAction.fillMenu(menu);
                }
            });
        }
        return menu;
    }

    static void refreshMenu() {
        GroupsMenuAction.fillMenu(menu);
    }

    private static void fillMenu(JMenu jMenu) {
        jMenu.removeAll();
        GroupsManager groupsManager = GroupsManager.getDefault();
        DocumentGroupImpl documentGroupImpl = groupsManager.getCurrentGroup();
        List<DocumentGroupImpl> list = groupsManager.getGroups();
        jMenu.add(new AbstractAction(NbBundle.getMessage(GroupsMenuAction.class, (String)"CTL_NewGroupAction")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupPanel newGroupPanel = new NewGroupPanel();
                newGroupPanel.showDialog();
            }
        });
        if (!list.isEmpty()) {
            jMenu.addSeparator();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(NbBundle.getMessage(GroupsMenuAction.class, (String)"CTL_CloseDocumentGroupAction")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GroupsMenuAction.closeGroup();
                }
            });
            jRadioButtonMenuItem.setSelected(null == documentGroupImpl);
            jMenu.add(jRadioButtonMenuItem);
            for (DocumentGroupImpl documentGroupImpl2 : list) {
                jRadioButtonMenuItem = new JRadioButtonMenuItem(new OpenGroupAction(documentGroupImpl2));
                jRadioButtonMenuItem.setSelected(documentGroupImpl2.equals(documentGroupImpl));
                jMenu.add(jRadioButtonMenuItem);
            }
            jMenu.addSeparator();
            jMenu.add(new AbstractAction(NbBundle.getMessage(GroupsMenuAction.class, (String)"CTL_ManageGroupsAction")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageGroupsPanel manageGroupsPanel = new ManageGroupsPanel();
                    manageGroupsPanel.showDialog();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private static void closeGroup() {
        final DocumentGroupImpl documentGroupImpl = GroupsManager.getDefault().getCurrentGroup();
        if (null != documentGroupImpl) {
            final PleaseWait pleaseWait = new PleaseWait();
            pleaseWait.install();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (documentGroupImpl.close()) {
                            GroupsManager.closeAllDocuments();
                        }
                        GroupsMenuAction.refreshMenu();
                    }
                    finally {
                        pleaseWait.uninstall();
                    }
                }
            });
        }
    }

    private static class OpenGroupAction
    extends AbstractAction {
        private final DocumentGroupImpl group;

        public OpenGroupAction(DocumentGroupImpl documentGroupImpl) {
            super(documentGroupImpl.toString());
            this.group = documentGroupImpl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final PleaseWait pleaseWait = new PleaseWait();
            pleaseWait.install();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        group.open();
                        GroupsMenuAction.refreshMenu();
                    }
                    finally {
                        pleaseWait.uninstall();
                    }
                }
            });
        }
    }
}

