/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.EjbRef;
import org.apache.naming.StringManager;
import org.apache.naming.factory.FactoryBase;

public class EjbFactory
extends FactoryBase {
    private static final StringManager sm = StringManager.getManager(EjbFactory.class);

    @Override
    protected boolean isReferenceTypeSupported(Object object) {
        return object instanceof EjbRef;
    }

    @Override
    protected ObjectFactory getDefaultFactory(Reference reference) throws NamingException {
        ObjectFactory objectFactory;
        String string = System.getProperty("javax.ejb.Factory", "org.apache.naming.factory.OpenEjbFactory");
        try {
            objectFactory = (ObjectFactory)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            if (throwable instanceof NamingException) {
                throw (NamingException)throwable;
            }
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof VirtualMachineError) {
                throw (VirtualMachineError)throwable;
            }
            NamingException namingException = new NamingException(sm.getString("factoryBase.factoryCreationError"));
            namingException.initCause(throwable);
            throw namingException;
        }
        return objectFactory;
    }

    @Override
    protected Object getLinked(Reference reference) throws NamingException {
        RefAddr refAddr = reference.get("link");
        if (refAddr != null) {
            String string = refAddr.getContent().toString();
            return new InitialContext().lookup(string);
        }
        return null;
    }
}

