/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/islandoftex/texplate/util/PathUtils;", "", "<init>", "()V", "TEMPLATES_FOLDER", "", "USER_APPLICATION_FOLDER", "userTemplatePath", "Ljava/nio/file/Path;", "getUserTemplatePath", "()Ljava/nio/file/Path;", "getTemplatePath", "name", "texplate"})
public final class PathUtils {
    @NotNull
    public static final PathUtils INSTANCE = new PathUtils();
    @NotNull
    private static final String TEMPLATES_FOLDER = "templates";
    @NotNull
    private static final String USER_APPLICATION_FOLDER = ".texplate";

    private PathUtils() {
    }

    private final Path getUserTemplatePath() {
        Object object;
        try {
            object = new String[]{USER_APPLICATION_FOLDER, TEMPLATES_FOLDER};
            object = Paths.get(System.getProperty("user.home"), object);
        }
        catch (RuntimeException e) {
            object = Paths.get(".", new String[0]);
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Path getTemplatePath(@NotNull String name) throws FileNotFoundException {
        Path path;
        Intrinsics.checkNotNullParameter(name, "name");
        if (StringsKt.endsWith$default(name, ".toml", false, 2, null) && Files.exists(Paths.get(name, new String[0]), new LinkOption[0])) {
            Path path2 = Paths.get(name, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            return path2;
        }
        String fullName = name + ".toml";
        Path reference = INSTANCE.getUserTemplatePath().resolve(fullName);
        if (Files.exists(reference, new LinkOption[0])) {
            Path path3 = reference;
            Intrinsics.checkNotNull(path3);
            path = path3;
        } else {
            Path path4;
            try {
                Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
                File file = tempFile.toFile();
                Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
                URL uRL = PathUtils.class.getResource("/org/islandoftex/texplate/templates/texplate-" + fullName);
                Intrinsics.checkNotNullExpressionValue(uRL, "getResource(...)");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes(uRL2);
                FilesKt.writeText$default(file, new String(byArray, charset), null, 2, null);
                path4 = tempFile;
            }
            catch (RuntimeException e) {
                throw new FileNotFoundException("I am sorry, but the template file '" + fullName + "' could not be found in the default template locations (system and user). Make sure the reference is correct and try again. For reference, these are the paths I searched: '" + INSTANCE.getUserTemplatePath() + "'.");
            }
            Path path5 = path4;
            Intrinsics.checkNotNull(path5);
            path = path5;
        }
        return path;
    }
}

