-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULLIF(1, 1) AS CONSTRAINT_CATALOG,
  STRIP(SYSCAT.KEYCOLUSE.TABSCHEMA) AS CONSTRAINT_SCHEMA,
  STRIP(SYSCAT.KEYCOLUSE.CONSTNAME) AS CONSTRAINT_NAME,
  NULLIF(1, 1) AS TABLE_CATALOG,
  STRIP(SYSCAT.KEYCOLUSE.TABSCHEMA) AS TABLE_SCHEMA,
  STRIP(SYSCAT.KEYCOLUSE.TABNAME) AS TABLE_NAME,
  STRIP(SYSCAT.KEYCOLUSE.COLNAME) AS COLUMN_NAME,
  STRIP(SYSCAT.KEYCOLUSE.COLSEQ) AS ORDINAL_POSITION
FROM
  SYSCAT.KEYCOLUSE  
UNION 
SELECT
  NULLIF(1, 1) AS CONSTRAINT_CATALOG,
  STRIP(SYSCAT.COLCHECKS.TABSCHEMA) AS CONSTRAINT_SCHEMA,
  STRIP(SYSCAT.COLCHECKS.CONSTNAME) AS CONSTRAINT_NAME,
  NULLIF(1, 1) AS TABLE_CATALOG,
  STRIP(SYSCAT.COLCHECKS.TABSCHEMA) AS TABLE_SCHEMA,
  STRIP(SYSCAT.COLCHECKS.TABNAME) AS TABLE_NAME,
  STRIP(SYSCAT.COLCHECKS.COLNAME) AS COLUMN_NAME,
  1 AS ORDINAL_POSITION
FROM
  SYSCAT.COLCHECKS  
WITH UR
