/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import tools.jackson.core.FormatFeature;

public enum JsonReadFeature implements FormatFeature
{
    ALLOW_JAVA_COMMENTS(false),
    ALLOW_YAML_COMMENTS(false),
    ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER(false),
    ALLOW_SINGLE_QUOTES(false),
    ALLOW_RS_CONTROL_CHAR(false),
    ALLOW_UNESCAPED_CONTROL_CHARS(false),
    ALLOW_UNQUOTED_PROPERTY_NAMES(false),
    ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS(false),
    ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS(false),
    ALLOW_LEADING_ZEROS_FOR_NUMBERS(false),
    ALLOW_NON_NUMERIC_NUMBERS(false),
    ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS(false),
    ALLOW_MISSING_VALUES(false),
    ALLOW_TRAILING_COMMA(false);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (JsonReadFeature f : JsonReadFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private JsonReadFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    @Override
    public boolean enabledByDefault() {
        return this._defaultState;
    }

    @Override
    public int getMask() {
        return this._mask;
    }

    @Override
    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }
}

