/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuffer;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.StandardCharsets;
import org.graalvm.collections.Pair;

public final class PickleUtils {
    public static final TruffleString T_MOD_COPYREG = PythonUtils.tsLiteral("copyreg");
    public static final TruffleString T_MOD_FUNCTOOLS = PythonUtils.tsLiteral("functools");
    public static final TruffleString T_MOD_CODECS = PythonUtils.tsLiteral("codecs");
    public static final TruffleString T_MOD_COMPAT_PICKLE = PythonUtils.tsLiteral("_compat_pickle");
    public static final TruffleString T_ATTR_EXT_REGISTRY = PythonUtils.tsLiteral("_extension_registry");
    public static final TruffleString T_ATTR_INV_REGISTRY = PythonUtils.tsLiteral("_inverted_registry");
    public static final TruffleString T_ATTR_EXT_CACHE = PythonUtils.tsLiteral("_extension_cache");
    public static final TruffleString T_ATTR_NAME_MAPPING = PythonUtils.tsLiteral("NAME_MAPPING");
    public static final TruffleString T_ATTR_IMPORT_MAPPING = PythonUtils.tsLiteral("IMPORT_MAPPING");
    public static final TruffleString T_ATTR_REVERSE_NAME_MAPPING = PythonUtils.tsLiteral("REVERSE_NAME_MAPPING");
    public static final TruffleString T_ATTR_REVERSE_IMPORT_MAPPING = PythonUtils.tsLiteral("REVERSE_IMPORT_MAPPING");
    public static final TruffleString T_CP_NAME_MAPPING = StringUtils.cat(T_MOD_COMPAT_PICKLE, StringLiterals.T_DOT, T_ATTR_NAME_MAPPING);
    public static final TruffleString T_CP_IMPORT_MAPPING = StringUtils.cat(T_MOD_COMPAT_PICKLE, StringLiterals.T_DOT, T_ATTR_IMPORT_MAPPING);
    public static final TruffleString T_CP_REVERSE_NAME_MAPPING = StringUtils.cat(T_MOD_COMPAT_PICKLE, StringLiterals.T_DOT, T_ATTR_REVERSE_NAME_MAPPING);
    public static final TruffleString T_CP_REVERSE_IMPORT_MAPPING = StringUtils.cat(T_MOD_COMPAT_PICKLE, StringLiterals.T_DOT, T_ATTR_REVERSE_IMPORT_MAPPING);
    public static final TruffleString T_METHOD_ENCODE = PythonUtils.tsLiteral("encode");
    public static final TruffleString T_METHOD_PARTIAL = PythonUtils.tsLiteral("partial");
    public static final TruffleString T_METHOD_READ = StringLiterals.T_READ;
    public static final TruffleString T_METHOD_READLINE = StringLiterals.T_READLINE;
    public static final TruffleString T_METHOD_READINTO = PythonUtils.tsLiteral("readinto");
    public static final TruffleString T_METHOD_PEEK = PythonUtils.tsLiteral("peek");
    public static final TruffleString T_METHOD_WRITE = PythonUtils.tsLiteral("write");
    public static final String J_METHOD_LOAD = "load";
    public static final String J_METHOD_DUMP = "dump";
    public static final String J_METHOD_PERSISTENT_ID = "persistent_id";
    public static final TruffleString T_METHOD_PERSISTENT_ID = PythonUtils.tsLiteral("persistent_id");
    public static final String J_METHOD_PERSISTENT_LOAD = "persistent_load";
    public static final TruffleString T_METHOD_PERSISTENT_LOAD = PythonUtils.tsLiteral("persistent_load");
    public static final String J_METHOD_FIND_CLASS = "find_class";
    public static final String J_METHOD_CLEAR_MEMO = "clear_memo";
    public static final String J_ATTR_DISPATCH_TABLE = "dispatch_table";
    public static final TruffleString T_ATTR_DISPATCH_TABLE = PythonUtils.tsLiteral("dispatch_table");
    public static final String J_ATTR_MEMO = "memo";
    public static final String J_ATTR_FAST = "fast";
    public static final String J_ATTR_BIN = "bin";
    public static final int READ_WHOLE_LINE = -1;
    public static final int PICKLE_PROTOCOL_HIGHEST = 5;
    public static final String J_DEFAULT_PICKLE_PROTOCOL = "4";
    public static final int BATCHSIZE = 1000;
    public static final int FAST_NESTING_LIMIT = 50;
    public static final int WRITE_BUF_SIZE = 4096;
    public static final int PREFETCH = 131072;
    public static final int FRAME_SIZE_MIN = 4;
    public static final int FRAME_SIZE_TARGET = 65536;
    public static final int FRAME_HEADER_SIZE = 9;
    public static final byte NO_OPCODE = 0;
    public static final byte OPCODE_MARK = 40;
    public static final byte OPCODE_STOP = 46;
    public static final byte OPCODE_POP = 48;
    public static final byte OPCODE_POP_MARK = 49;
    public static final byte OPCODE_DUP = 50;
    public static final byte OPCODE_FLOAT = 70;
    public static final byte OPCODE_INT = 73;
    public static final byte OPCODE_BININT = 74;
    public static final byte OPCODE_BININT1 = 75;
    public static final byte OPCODE_LONG = 76;
    public static final byte OPCODE_BININT2 = 77;
    public static final byte OPCODE_NONE = 78;
    public static final byte OPCODE_PERSID = 80;
    public static final byte OPCODE_BINPERSID = 81;
    public static final byte OPCODE_REDUCE = 82;
    public static final byte OPCODE_STRING = 83;
    public static final byte OPCODE_BINSTRING = 84;
    public static final byte OPCODE_SHORT_BINSTRING = 85;
    public static final byte OPCODE_UNICODE = 86;
    public static final byte OPCODE_BINUNICODE = 88;
    public static final byte OPCODE_APPEND = 97;
    public static final byte OPCODE_BUILD = 98;
    public static final byte OPCODE_GLOBAL = 99;
    public static final byte OPCODE_DICT = 100;
    public static final byte OPCODE_EMPTY_DICT = 125;
    public static final byte OPCODE_APPENDS = 101;
    public static final byte OPCODE_GET = 103;
    public static final byte OPCODE_BINGET = 104;
    public static final byte OPCODE_INST = 105;
    public static final byte OPCODE_LONG_BINGET = 106;
    public static final byte OPCODE_LIST = 108;
    public static final byte OPCODE_EMPTY_LIST = 93;
    public static final byte OPCODE_OBJ = 111;
    public static final byte OPCODE_PUT = 112;
    public static final byte OPCODE_BINPUT = 113;
    public static final byte OPCODE_LONG_BINPUT = 114;
    public static final byte OPCODE_SETITEM = 115;
    public static final byte OPCODE_TUPLE = 116;
    public static final byte OPCODE_EMPTY_TUPLE = 41;
    public static final byte OPCODE_SETITEMS = 117;
    public static final byte OPCODE_BINFLOAT = 71;
    public static final byte OPCODE_PROTO = -128;
    public static final byte OPCODE_NEWOBJ = -127;
    public static final byte OPCODE_EXT1 = -126;
    public static final byte OPCODE_EXT2 = -125;
    public static final byte OPCODE_EXT4 = -124;
    public static final byte OPCODE_TUPLE1 = -123;
    public static final byte OPCODE_TUPLE2 = -122;
    public static final byte OPCODE_TUPLE3 = -121;
    public static final byte OPCODE_NEWTRUE = -120;
    public static final byte OPCODE_NEWFALSE = -119;
    public static final byte OPCODE_LONG1 = -118;
    public static final byte OPCODE_LONG4 = -117;
    public static final byte OPCODE_BINBYTES = 66;
    public static final byte OPCODE_SHORT_BINBYTES = 67;
    public static final byte OPCODE_SHORT_BINUNICODE = -116;
    public static final byte OPCODE_BINUNICODE8 = -115;
    public static final byte OPCODE_BINBYTES8 = -114;
    public static final byte OPCODE_EMPTY_SET = -113;
    public static final byte OPCODE_ADDITEMS = -112;
    public static final byte OPCODE_FROZENSET = -111;
    public static final byte OPCODE_NEWOBJ_EX = -110;
    public static final byte OPCODE_STACK_GLOBAL = -109;
    public static final byte OPCODE_MEMOIZE = -108;
    public static final byte OPCODE_FRAME = -107;
    public static final byte OPCODE_BYTEARRAY8 = -106;
    public static final byte OPCODE_NEXT_BUFFER = -105;
    public static final byte OPCODE_READONLY_BUFFER = -104;
    public static final TruffleString T_PROTO_LE2_TRUE = PythonUtils.tsLiteral("I01\n");
    public static final TruffleString T_PROTO_LE2_FALSE = PythonUtils.tsLiteral("I00\n");

    @ExplodeLoop
    public static void writeSize64(byte[] out, int start, int value) {
        int i;
        int sizeofSizeT = 4;
        for (i = 0; i < 4; ++i) {
            out[start + i] = (byte)(value >> 8 * i & 0xFF);
        }
        for (i = 4; i < 8; ++i) {
            out[start + i] = 0;
        }
    }

    public static byte[] resize(byte[] src, int newSize) {
        byte[] newBytes = new byte[newSize];
        if (src != null) {
            PythonUtils.arraycopy(src, 0, newBytes, 0, Math.min(newSize, src.length));
        }
        return newBytes;
    }

    private static int arrayCopyWithNewLine(byte[] dst, int offset, byte[] src) {
        PythonUtils.arraycopy(src, 0, dst, offset, src.length);
        int len = src.length + 2;
        dst[len - 1] = 10;
        return len;
    }

    public static int toAsciiBytesWithNewLine(byte[] dst, int offset, long value, TruffleString.FromLongNode fromLongNode, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        TruffleString s = fromLongNode.execute(value, TruffleString.Encoding.US_ASCII, true);
        byte[] buf = new byte[s.byteLength(TruffleString.Encoding.US_ASCII)];
        copyToByteArrayNode.execute((AbstractTruffleString)s, 0, buf, 0, buf.length, TruffleString.Encoding.US_ASCII);
        return PickleUtils.arrayCopyWithNewLine(dst, offset, buf);
    }

    public static int getStringSize(byte[] bytes) {
        int len = bytes.length > 0 && bytes[bytes.length - 1] == 10 ? bytes.length - 1 : bytes.length;
        return len > 0 && bytes[len - 1] == 0 ? len - 1 : len;
    }

    public static TruffleString getValidIntString(byte[] bytes) {
        return PickleUtils.getValidIntASCIIString(bytes, TruffleString.FromByteArrayNode.getUncached());
    }

    public static int asciiBytesToInt(byte[] bytes, TruffleString.ParseIntNode parseIntNode, TruffleString.FromByteArrayNode fromByteArrayNode) throws TruffleString.NumberFormatException {
        return parseIntNode.execute((AbstractTruffleString)PickleUtils.getValidIntASCIIString(bytes, fromByteArrayNode), 10);
    }

    public static long asciiBytesToLong(byte[] bytes, TruffleString.ParseLongNode parseLongNode, TruffleString.FromByteArrayNode fromByteArrayNode) throws TruffleString.NumberFormatException {
        return parseLongNode.execute((AbstractTruffleString)PickleUtils.getValidIntASCIIString(bytes, fromByteArrayNode), 10);
    }

    private static TruffleString getValidIntASCIIString(byte[] bytes, TruffleString.FromByteArrayNode fromByteArray) {
        return fromByteArray.execute(bytes, 0, PickleUtils.getStringSize(bytes), TruffleString.Encoding.US_ASCII, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString doubleToAsciiString(double value) {
        return PythonUtils.toTruffleStringUncached(new String(Double.toString(value).getBytes(StandardCharsets.US_ASCII), StandardCharsets.US_ASCII));
    }

    @CompilerDirectives.TruffleBoundary
    public static double asciiBytesToDouble(byte[] bytes) {
        int len = bytes[bytes.length - 1] == 10 ? bytes.length - 1 : bytes.length;
        return Double.parseDouble(new String(bytes, 0, len, StandardCharsets.US_ASCII));
    }

    @CompilerDirectives.TruffleBoundary
    public static double asciiBytesToDouble(Node node, byte[] bytes, PythonBuiltinClassType errorType) {
        try {
            return PickleUtils.asciiBytesToDouble(bytes);
        }
        catch (NumberFormatException nfe) {
            throw PRaiseNode.raiseStatic(node, errorType);
        }
    }

    public static byte[] encodeUTF8Strict(TruffleString str, TruffleString.SwitchEncodingNode switchEncodingNode, TruffleString.CopyToByteArrayNode copyToByteArrayNode, TruffleString.GetCodeRangeNode getCodeRangeNode) {
        return PickleUtils.encodeStrict(str, switchEncodingNode, TruffleString.Encoding.UTF_8, copyToByteArrayNode, getCodeRangeNode);
    }

    public static byte[] encodeStrict(TruffleString ts, TruffleString.SwitchEncodingNode switchEncodingNode, TruffleString.Encoding encoding, TruffleString.CopyToByteArrayNode copyToByteArrayNode, TruffleString.GetCodeRangeNode getCodeRangeNode) {
        if (getCodeRangeNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING) == TruffleString.CodeRange.BROKEN) {
            return null;
        }
        TruffleString s = switchEncodingNode.execute((AbstractTruffleString)ts, encoding);
        byte[] buf = new byte[s.byteLength(encoding)];
        copyToByteArrayNode.execute((AbstractTruffleString)s, 0, buf, 0, buf.length, encoding);
        return buf;
    }

    public static TruffleString decodeUTF8Strict(byte[] data, int len, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        return PickleUtils.decodeStrict(data, len, fromByteArrayNode, TruffleString.Encoding.UTF_8, switchEncodingNode);
    }

    public static TruffleString decodeLatin1Strict(byte[] data, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        return PickleUtils.decodeStrict(data, data.length, fromByteArrayNode, TruffleString.Encoding.ISO_8859_1, switchEncodingNode);
    }

    private static TruffleString decodeStrict(byte[] data, int len, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.Encoding encoding, TruffleString.SwitchEncodingNode switchEncodingNode) {
        TruffleString ret = fromByteArrayNode.execute(data, 0, len, encoding, true);
        return switchEncodingNode.execute((AbstractTruffleString)ret, PythonUtils.TS_ENCODING);
    }

    public static byte[] rawUnicodeEscape(TruffleString unicode, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        int len = codePointLengthNode.execute((AbstractTruffleString)unicode, PythonUtils.TS_ENCODING);
        ByteArrayBuffer buffer = new ByteArrayBuffer(len);
        for (int i = 0; i < len; ++i) {
            int ch = codePointAtIndexNode.execute((AbstractTruffleString)unicode, i, PythonUtils.TS_ENCODING);
            if (ch >= 65536) {
                buffer.append(92);
                buffer.append(85);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 28 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 24 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 20 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 16 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 12 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 8 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 4 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch & 0xF]);
                continue;
            }
            if (ch >= 256 || ch == 92 || ch == 0 || ch == 10 || ch == 13 || ch == 26) {
                buffer.append(92);
                buffer.append(117);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 12 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 8 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch >> 4 & 0xF]);
                buffer.append((char)BytesUtils.HEXDIGITS[ch & 0xF]);
                continue;
            }
            buffer.append((char)ch);
        }
        return buffer.getByteArray();
    }

    public static Pair<Object, Object> initMethodRef(VirtualFrame frame, Node inliningTarget, PyObjectLookupAttr lookup, Object receiver, TruffleString identifier) {
        Object func = lookup.execute((Frame)frame, inliningTarget, receiver, identifier);
        if (func == PNone.NO_VALUE) {
            return Pair.create(null, null);
        }
        if (func instanceof PMethod && ((PMethod)func).getSelf() == receiver) {
            return Pair.create((Object)((PMethod)func).getFunction(), (Object)receiver);
        }
        if (func instanceof PBuiltinMethod && ((PBuiltinMethod)func).getSelf() == receiver) {
            return Pair.create((Object)((PBuiltinMethod)func).getFunction(), (Object)receiver);
        }
        return Pair.create((Object)func, null);
    }

    public static Object reconstructMethod(PythonLanguage language, Object func, Object self) {
        if (self != null) {
            return PFactory.createMethod(language, self, func);
        }
        return func;
    }
}

