/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.NaturalIdLogging;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.NaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.stat.spi.StatisticsImplementor;

public abstract class AbstractNaturalIdLoader<T>
implements NaturalIdLoader<T> {
    private final NaturalIdMapping naturalIdMapping;
    private final EntityMappingType entityDescriptor;

    public AbstractNaturalIdLoader(NaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        this.naturalIdMapping = naturalIdMapping;
        this.entityDescriptor = entityDescriptor;
    }

    protected EntityMappingType entityDescriptor() {
        return this.entityDescriptor;
    }

    protected NaturalIdMapping naturalIdMapping() {
        return this.naturalIdMapping;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor();
    }

    @Override
    public T load(Object naturalIdValue, NaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        LockOptions lockOptions = options.getLockOptions() == null ? new LockOptions() : options.getLockOptions();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect(this.getLoadable(), null, true, Collections.emptyList(), null, 1, session.getLoadQueryInfluencers(), lockOptions, JdbcParametersList.newBuilder()::add, factory);
        QuerySpec querySpec = sqlSelect.getQuerySpec();
        return (T)this.executeNaturalIdQuery(naturalIdValue, lockOptions, sqlSelect, querySpec.getFromClause().getRoots().get(0), querySpec::applyPredicate, new LoaderSqlAstCreationState(querySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), lockOptions, (fetchParent, creationState) -> ImmutableFetchList.EMPTY, true, new LoadQueryInfluencers(factory), factory.getSqlTranslationEngine()), session);
    }

    protected abstract void applyNaturalIdRestriction(Object var1, TableGroup var2, Consumer<Predicate> var3, BiConsumer<JdbcParameter, JdbcParameterBinding> var4, LoaderSqlAstCreationState var5, SharedSessionContractImplementor var6);

    protected Expression resolveColumnReference(TableGroup rootTableGroup, SelectableMapping selectableMapping, SqlExpressionResolver sqlExpressionResolver) {
        TableReference tableReference = rootTableGroup.getTableReference(rootTableGroup.getNavigablePath(), selectableMapping.getContainingTableExpression());
        if (tableReference == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Unable to locate TableReference for '%s' : %s", selectableMapping.getContainingTableExpression(), rootTableGroup));
        }
        return sqlExpressionResolver.resolveSqlExpression(tableReference, selectableMapping);
    }

    @Override
    public Object resolveNaturalIdToId(Object naturalIdValue, SharedSessionContractImplementor session) {
        if (NaturalIdLogging.NATURAL_ID_LOGGER.isTraceEnabled()) {
            Object object;
            String string = this.entityDescriptor.getEntityName();
            if (naturalIdValue instanceof Object[]) {
                Object[] array = (Object[])naturalIdValue;
                object = Arrays.toString(array);
            } else {
                object = naturalIdValue;
            }
            NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.retrievingIdForNaturalId(string, object);
        }
        SessionFactoryImplementor factory = session.getFactory();
        NavigablePath entityPath = new NavigablePath(this.entityDescriptor.getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), LockOptions.NONE, (fetchParent, creationState) -> ImmutableFetchList.EMPTY, true, new LoadQueryInfluencers(factory), factory.getSqlTranslationEngine());
        TableGroup rootTableGroup = this.entityDescriptor.createRootTableGroup(true, entityPath, null, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        DomainResult domainResult = this.entityDescriptor.getIdentifierMapping().createDomainResult(rootTableGroup.getNavigablePath().append("{id}"), rootTableGroup, null, sqlAstCreationState);
        return this.executeNaturalIdQuery(naturalIdValue, LockOptions.NONE, new SelectStatement(rootQuerySpec, Collections.singletonList(domainResult)), rootTableGroup, rootQuerySpec::applyPredicate, sqlAstCreationState, session);
    }

    protected <R> R executeNaturalIdQuery(Object naturalIdValue, LockOptions lockOptions, SelectStatement sqlSelect, TableGroup rootTableGroup, Consumer<Predicate> predicateConsumer, LoaderSqlAstCreationState sqlAstCreationState, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(this.naturalIdMapping.getJdbcTypeCount());
        this.applyNaturalIdRestriction(this.naturalIdMapping().normalizeInput(naturalIdValue), rootTableGroup, predicateConsumer, bindings::addBinding, sqlAstCreationState, session);
        SimpleQueryOptions queryOptions = new SimpleQueryOptions(lockOptions, false);
        JdbcOperationQuerySelect jdbcSelect = AbstractNaturalIdLoader.createJdbcOperationQuerySelect(sqlSelect, factory, bindings, queryOptions);
        StatisticsImplementor statistics = factory.getStatistics();
        boolean statisticsEnabled = statistics.isStatisticsEnabled();
        long startTime = statisticsEnabled ? System.nanoTime() : -1L;
        List results = factory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, bindings, new NaturalIdLoaderWithOptionsExecutionContext(session, queryOptions), RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
        if (statisticsEnabled) {
            statistics.naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startTime);
        }
        return switch (results.size()) {
            case 0 -> null;
            case 1 -> results.get(0);
            default -> throw new HibernateException(String.format("Query by natural id returned more that one row: %s", this.entityDescriptor.getEntityName()));
        };
    }

    private static JdbcOperationQuerySelect createJdbcOperationQuerySelect(SelectStatement sqlSelect, SessionFactoryImplementor factory, JdbcParameterBindings bindings, QueryOptions queryOptions) {
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, sqlSelect).translate(bindings, queryOptions);
    }

    @Override
    public Object resolveIdToNaturalId(Object id, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        EntityIdentifierMapping identifierMapping = this.entityDescriptor().getIdentifierMapping();
        JdbcParametersList.Builder builder = JdbcParametersList.newBuilder();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor(), Collections.singletonList(this.naturalIdMapping()), identifierMapping, null, 1, session.getLoadQueryInfluencers(), new LockOptions(), builder::add, factory);
        JdbcParametersList jdbcParameters = builder.build();
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = bindings.registerParametersForEachJdbcValue(id, identifierMapping, jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        List results = factory.getJdbcServices().getJdbcSelectExecutor().list(AbstractNaturalIdLoader.createJdbcOperationQuerySelect(sqlSelect, factory, bindings, QueryOptions.NONE), bindings, new NoCallbackExecutionContext(session), RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
        return switch (results.size()) {
            case 0 -> null;
            case 1 -> results.get(0);
            default -> throw new HibernateException(String.format("Resolving id to natural id returned more that one row: %s #%s", this.entityDescriptor().getEntityName(), id));
        };
    }

    void applyRestriction(TableGroup rootTableGroup, Consumer<Predicate> predicateConsumer, BiConsumer<JdbcParameter, JdbcParameterBinding> jdbcParameterConsumer, Object jdbcValue, SelectableMapping jdbcValueMapping, SqlExpressionResolver expressionResolver) {
        Expression columnReference = this.resolveColumnReference(rootTableGroup, jdbcValueMapping, expressionResolver);
        if (jdbcValue == null) {
            predicateConsumer.accept(new NullnessPredicate(columnReference));
        } else {
            SqlTypedMappingJdbcParameter jdbcParameter = new SqlTypedMappingJdbcParameter(jdbcValueMapping);
            ComparisonPredicate predicate = new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, jdbcParameter);
            predicateConsumer.accept(predicate);
            jdbcParameterConsumer.accept(jdbcParameter, new JdbcParameterBindingImpl(jdbcValueMapping.getJdbcMapping(), jdbcValue));
        }
    }

    private static class NaturalIdLoaderWithOptionsExecutionContext
    extends BaseExecutionContext {
        private final Callback callback;
        private final QueryOptions queryOptions;

        public NaturalIdLoaderWithOptionsExecutionContext(SharedSessionContractImplementor session, QueryOptions queryOptions) {
            super(session);
            this.queryOptions = queryOptions;
            this.callback = new CallbackImpl();
        }

        @Override
        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        @Override
        public Callback getCallback() {
            return this.callback;
        }
    }
}

