/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfiguredPushHandler
implements HttpHandler {
    private final PathMatcher<String[]> pathMatcher = new PathMatcher();
    private final HttpHandler next;
    private final Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();

    public ConfiguredPushHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PathMatcher.PathMatch<String[]> result;
        if (exchange.isPushSupported() && (result = this.pathMatcher.match(exchange.getRelativePath())) != null) {
            String[] value = result.getValue();
            for (int i = 0; i < value.length; ++i) {
                exchange.pushResource(value[i], "GET", this.requestHeaders);
            }
        }
        this.next.handleRequest(exchange);
    }

    public ConfiguredPushHandler addRequestHeader(String name, String value) {
        this.requestHeaders.computeIfAbsent(name, a -> new ArrayList()).add(value);
        return this;
    }

    public ConfiguredPushHandler addRoute(String url, String ... resourcesToPush) {
        if (url.endsWith("/*")) {
            String partial = url.substring(0, url.length() - 1);
            this.pathMatcher.addPrefixPath(partial, resourcesToPush);
        } else {
            this.pathMatcher.addExactPath(url, resourcesToPush);
        }
        return this;
    }
}

