/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.configuration.inputs;

import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class AccessTrackingSet<E>
extends ForwardingSet<E>
implements Serializable {
    private final Set<? extends E> delegate;
    private final Listener listener;
    private final Function<E, E> factory;

    public AccessTrackingSet(Set<? extends E> delegate, Listener listener) {
        this(delegate, listener, Function.identity());
    }

    public AccessTrackingSet(Set<? extends E> delegate, Listener listener, Function<E, E> factory) {
        this.delegate = delegate;
        this.listener = listener;
        this.factory = factory;
    }

    public boolean contains(@Nullable Object o) {
        boolean result = this.delegate.contains(o);
        this.listener.onAccess(o);
        return result;
    }

    public boolean containsAll(@NonNull Collection<?> collection) {
        boolean result = this.delegate.containsAll(collection);
        for (Object o : collection) {
            this.listener.onAccess(o);
        }
        return result;
    }

    public boolean remove(@Nullable Object o) {
        this.listener.onAccess(o);
        this.listener.onRemove(o);
        return this.delegate.remove(o);
    }

    public boolean removeAll(Collection<?> collection) {
        for (Object o : collection) {
            this.listener.onAccess(o);
            this.listener.onRemove(o);
        }
        return this.delegate.removeAll(collection);
    }

    public void clear() {
        this.delegate.clear();
        this.listener.onClear();
    }

    public Iterator<E> iterator() {
        this.reportAggregatingAccess();
        return Iterators.transform(this.delegate().iterator(), this.factory::apply);
    }

    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    public boolean equals(@Nullable Object object) {
        this.reportAggregatingAccess();
        return super.equals(object);
    }

    public int hashCode() {
        this.reportAggregatingAccess();
        return super.hashCode();
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public <T> T[] toArray(T[] array) {
        this.reportAggregatingAccess();
        T[] result = this.delegate().toArray(array);
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.factory.apply(result[i]);
        }
        return result;
    }

    protected Set<E> delegate() {
        return this.delegate;
    }

    private void reportAggregatingAccess() {
        this.listener.onAggregatingAccess();
    }

    private Object writeReplace() {
        this.reportAggregatingAccess();
        return new SerializedForm(new ArrayList<E>(this.delegate));
    }

    public static interface Listener {
        public void onAccess(@Nullable Object var1);

        public void onAggregatingAccess();

        public void onRemove(@Nullable Object var1);

        public void onClear();
    }

    private static class SerializedForm
    implements Serializable {
        private final List<?> delegate;

        private SerializedForm(List<?> delegate) {
            this.delegate = delegate;
        }

        private Object readResolve() {
            return new LinkedHashSet(Objects.requireNonNull(this.delegate));
        }
    }
}

