# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # A detailed representation of an Apt artifact. Information in the record
        # is derived from the archive's control file.
        # See https://www.debian.org/doc/debian-policy/ch-controlfields.html
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The Artifact Registry resource name of the artifact.
        # @!attribute [r] package_name
        #   @return [::String]
        #     Output only. The Apt package name of the artifact.
        # @!attribute [r] package_type
        #   @return [::Google::Cloud::ArtifactRegistry::V1::AptArtifact::PackageType]
        #     Output only. An artifact is a binary or source package.
        # @!attribute [r] architecture
        #   @return [::String]
        #     Output only. Operating system architecture of the artifact.
        # @!attribute [r] component
        #   @return [::String]
        #     Output only. Repository component of the artifact.
        # @!attribute [r] control_file
        #   @return [::String]
        #     Output only. Contents of the artifact's control metadata file.
        class AptArtifact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Package type is either binary or source.
          module PackageType
            # Package type is not specified.
            PACKAGE_TYPE_UNSPECIFIED = 0

            # Binary package.
            BINARY = 1

            # Source package.
            SOURCE = 2
          end
        end

        # Google Cloud Storage location where the artifacts currently reside.
        # @!attribute [rw] uris
        #   @return [::Array<::String>]
        #     Cloud Storage paths URI (e.g., gs://my_bucket//my_object).
        # @!attribute [rw] use_wildcards
        #   @return [::Boolean]
        #     Supports URI wildcards for matching multiple objects from a single URI.
        class ImportAptArtifactsGcsSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to import new apt artifacts.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::ArtifactRegistry::V1::ImportAptArtifactsGcsSource]
        #     Google Cloud Storage location where input content is located.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The name of the parent resource where the artifacts will be imported.
        class ImportAptArtifactsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Error information explaining why a package was not imported.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::ArtifactRegistry::V1::ImportAptArtifactsGcsSource]
        #     Google Cloud Storage location requested.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     The detailed error status.
        class ImportAptArtifactsErrorInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message from importing APT artifacts.
        # @!attribute [rw] apt_artifacts
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::AptArtifact>]
        #     The Apt artifacts imported.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::ImportAptArtifactsErrorInfo>]
        #     Detailed error info for packages that were not imported.
        class ImportAptArtifactsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The operation metadata for importing artifacts.
        class ImportAptArtifactsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
