/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.idea.highlighter.IdeRenderers;
import org.jetbrains.kotlin.idea.highlighter.renderersUtil.RenderersUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingFormat;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.KotlinType;

public class HtmlTabledDescriptorRenderer
extends TabledDescriptorRenderer {
    private static final DescriptorRenderer.ValueParametersHandler VALUE_PARAMETERS_HANDLER = new DescriptorRenderer.ValueParametersHandler(){

        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder2) {
            if (parameter == null) {
                1.$$$reportNull$$$0(0);
            }
            if (builder2 == null) {
                1.$$$reportNull$$$0(1);
            }
            builder2.append("<td align=\"right\" style=\"white-space:nowrap;font-weight:bold;\">");
        }

        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder2) {
            boolean last;
            if (parameter == null) {
                1.$$$reportNull$$$0(2);
            }
            if (builder2 == null) {
                1.$$$reportNull$$$0(3);
            }
            boolean bl = last = parameterIndex == parameterCount - 1;
            if (!last) {
                builder2.append(",");
            }
            builder2.append("</td>");
        }

        public void appendBeforeValueParameters(int parameterCount, @NotNull StringBuilder builder2) {
            if (builder2 == null) {
                1.$$$reportNull$$$0(4);
            }
            builder2.append("</td>");
            if (parameterCount == 0) {
                HtmlTabledDescriptorRenderer.tdBold(builder2, "( )");
            } else {
                HtmlTabledDescriptorRenderer.tdBold(builder2, "(");
            }
        }

        public void appendAfterValueParameters(int parameterCount, @NotNull StringBuilder builder2) {
            if (builder2 == null) {
                1.$$$reportNull$$$0(5);
            }
            if (parameterCount != 0) {
                HtmlTabledDescriptorRenderer.tdBold(builder2, ")");
            }
            builder2.append("<td style=\"white-space:nowrap;font-weight:bold;\">");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendBeforeValueParameter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendAfterValueParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendBeforeValueParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendAfterValueParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final DiagnosticParameterRenderer<DeclarationDescriptor> DESCRIPTOR_IN_TABLE = new SmartDescriptorRenderer(DescriptorRenderer.Companion.withOptions((Function1)new Function1<DescriptorRendererOptions, Unit>(){

        public Unit invoke(DescriptorRendererOptions options2) {
            options2.setWithDefinedIn(false);
            options2.setModifiers(Collections.emptySet());
            options2.setValueParametersHandler(VALUE_PARAMETERS_HANDLER);
            options2.setTextFormat(RenderingFormat.HTML);
            return Unit.INSTANCE;
        }
    }));

    @NotNull
    public DiagnosticParameterRenderer<KotlinType> getTypeRenderer() {
        SmartTypeRenderer smartTypeRenderer = IdeRenderers.HTML_RENDER_TYPE;
        if (smartTypeRenderer == null) {
            HtmlTabledDescriptorRenderer.$$$reportNull$$$0(0);
        }
        return smartTypeRenderer;
    }

    protected void renderText(TabledDescriptorRenderer.TextRenderer textRenderer, StringBuilder result2) {
        for (TabledDescriptorRenderer.TextRenderer.TextElement element : textRenderer.elements) {
            HtmlTabledDescriptorRenderer.renderText(result2, element.type, element.text);
        }
    }

    private static void renderText(StringBuilder result2, TabledDescriptorRenderer.TextElementType elementType, String text) {
        if (elementType == TabledDescriptorRenderer.TextElementType.DEFAULT) {
            result2.append(text);
        } else if (elementType == TabledDescriptorRenderer.TextElementType.ERROR) {
            result2.append(RenderersUtilKt.renderError(text));
        } else if (elementType == TabledDescriptorRenderer.TextElementType.STRONG) {
            result2.append(RenderersUtilKt.renderStrong(text));
        }
    }

    private static int countColumnNumber(TabledDescriptorRenderer.TableRenderer table) {
        int argumentsNumber = 0;
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            int argumentTypesNumber;
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                int valueParametersNumber = ((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor.getValueParameters().size();
                if (valueParametersNumber <= argumentsNumber) continue;
                argumentsNumber = valueParametersNumber;
                continue;
            }
            if (!(row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) || (argumentTypesNumber = ((TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row).argumentTypes.size()) <= argumentsNumber) continue;
            argumentsNumber = argumentTypesNumber;
        }
        return argumentsNumber + 6;
    }

    protected void renderTable(TabledDescriptorRenderer.TableRenderer table, StringBuilder result2) {
        if (table.rows.isEmpty()) {
            return;
        }
        RenderingContext context2 = HtmlTabledDescriptorRenderer.computeRenderingContext((TabledDescriptorRenderer.TableRenderer)table);
        int rowsNumber = HtmlTabledDescriptorRenderer.countColumnNumber(table);
        result2.append("<table>");
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            result2.append("<tr>");
            if (row instanceof TabledDescriptorRenderer.TextRenderer) {
                StringBuilder rowText = new StringBuilder();
                this.renderText((TabledDescriptorRenderer.TextRenderer)row, rowText);
                HtmlTabledDescriptorRenderer.tdColspan(result2, rowText.toString(), rowsNumber);
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                HtmlTabledDescriptorRenderer.tdSpace(result2);
                HtmlTabledDescriptorRenderer.tdRightBoldColspan(result2, 2, DESCRIPTOR_IN_TABLE.render((Object)((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor, context2));
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) {
                TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, functionArgumentsRow.isErrorPosition, result2, context2);
            }
            result2.append("</tr>");
        }
        result2.append("</table>");
    }

    private void renderFunctionArguments(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes, Predicate<ConstraintPosition> isErrorPosition, StringBuilder result2, @NotNull RenderingContext context2) {
        if (argumentTypes == null) {
            HtmlTabledDescriptorRenderer.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            HtmlTabledDescriptorRenderer.$$$reportNull$$$0(2);
        }
        boolean hasReceiver = receiverType != null;
        HtmlTabledDescriptorRenderer.tdSpace(result2);
        String receiver2 = "";
        if (hasReceiver) {
            boolean error = false;
            if (isErrorPosition.test(ConstraintPositionKind.RECEIVER_POSITION.position())) {
                error = true;
            }
            receiver2 = KotlinBaseFe10HighlightingBundle.message("function.receiver.0", RenderersUtilKt.renderStrong(this.getTypeRenderer().render((Object)receiverType, context2), error));
        }
        HtmlTabledDescriptorRenderer.td(result2, receiver2);
        HtmlTabledDescriptorRenderer.td(result2, hasReceiver ? KotlinBaseFe10HighlightingBundle.message("function.arguments", new Object[0]) : "");
        if (argumentTypes.isEmpty()) {
            HtmlTabledDescriptorRenderer.tdBold(result2, "( )");
            return;
        }
        HtmlTabledDescriptorRenderer.td(result2, RenderersUtilKt.renderStrong("("));
        int i2 = 0;
        Iterator<KotlinType> iterator2 = argumentTypes.iterator();
        while (iterator2.hasNext()) {
            KotlinType argumentType = iterator2.next();
            boolean error = false;
            if (isErrorPosition.test(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(i2))) {
                error = true;
            }
            String renderedArgument = argumentType == null ? "unknown" : this.getTypeRenderer().render((Object)argumentType, context2);
            HtmlTabledDescriptorRenderer.tdRight(result2, RenderersUtilKt.renderStrong(renderedArgument, error) + (iterator2.hasNext() ? RenderersUtilKt.renderStrong(",") : ""));
            ++i2;
        }
        HtmlTabledDescriptorRenderer.td(result2, RenderersUtilKt.renderStrong(")"));
    }

    public static HtmlTabledDescriptorRenderer create() {
        return new HtmlTabledDescriptorRenderer();
    }

    protected HtmlTabledDescriptorRenderer() {
    }

    private static void td(StringBuilder builder2, String text) {
        builder2.append("<td style=\"white-space:nowrap;\">").append(text).append("</td>");
    }

    private static void tdSpace(StringBuilder builder2) {
        builder2.append("<td width=\"10%\"></td>");
    }

    private static void tdColspan(StringBuilder builder2, String text, int colspan) {
        builder2.append("<td colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;\">").append(text).append("</td>");
    }

    private static void tdBold(StringBuilder builder2, String text) {
        builder2.append("<td style=\"white-space:nowrap;font-weight:bold;\">").append(text).append("</td>");
    }

    private static void tdRight(StringBuilder builder2, String text) {
        builder2.append("<td align=\"right\" style=\"white-space:nowrap;\">").append(text).append("</td>");
    }

    private static void tdRightBoldColspan(StringBuilder builder2, int colspan, String text) {
        builder2.append("<td align=\"right\" colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;font-weight:bold;\">").append(text).append("</td>");
    }

    public static String tableForTypes(String message2, String firstDescription, TabledDescriptorRenderer.TextElementType firstType, String secondDescription, TabledDescriptorRenderer.TextElementType secondType) {
        StringBuilder result2 = new StringBuilder();
        result2.append("<html>").append(message2);
        result2.append("<table><tr><td>").append(firstDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result2, firstType, "{0}");
        result2.append("</td></tr><tr><td>").append(secondDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result2, secondType, "{1}");
        result2.append("</td></tr></table></html>");
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderFunctionArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

