/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "isExplicit", "", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyFieldTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyFieldTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,75:1\n56#2:76\n56#2:77\n56#2:78\n*S KotlinDebug\n*F\n+ 1 FirPropertyFieldTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker\n*L\n42#1:76\n46#1:77\n50#1:78\n*E\n"})
public final class FirPropertyFieldTypeChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyFieldTypeChecker INSTANCE = new FirPropertyFieldTypeChecker();

    private FirPropertyFieldTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirBackingField firBackingField = declaration.getBackingField();
        if (firBackingField == null) {
            return;
        }
        FirBackingField backingField = firBackingField;
        if (!DeclarationAttributesKt.getHasExplicitBackingField(declaration)) {
            return;
        }
        TypeCheckerState typeCheckerContext = TypeCheckerProviderContext.newTypeCheckerState$default((TypeCheckerProviderContext)TypeComponentsKt.getTypeContext(context2.getSession()), (boolean)false, (boolean)false, (boolean)false, (int)4, null);
        if (declaration.getInitializer() != null) {
            FirExpression firExpression = declaration.getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null)), (KtDiagnosticFactory0)FirErrors.INSTANCE.getPROPERTY_INITIALIZER_WITH_EXPLICIT_FIELD_DECLARATION(), null, (int)8, null);
        }
        if (declaration.isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVAR_PROPERTY_WITH_EXPLICIT_BACKING_FIELD(), null, (int)8, null);
        }
        FirMemberDeclaration $this$isLateInit$iv = backingField;
        boolean $i$f$isLateInit = false;
        if ($this$isLateInit$iv.getStatus().isLateInit() && declaration.isVal()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)backingField.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getLATEINIT_FIELD_IN_VAL_PROPERTY(), null, (int)8, null);
        }
        if (backingField.getInitializer() != null) {
            $this$isLateInit$iv = backingField;
            $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)backingField.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getLATEINIT_PROPERTY_FIELD_DECLARATION_WITH_INITIALIZER(), null, (int)8, null);
            }
        }
        $this$isLateInit$iv = backingField;
        $i$f$isLateInit = false;
        if ($this$isLateInit$iv.getStatus().isLateInit() && TypeUtilsKt.canBeNull$default(FirTypeUtilsKt.getConeType(backingField.getReturnTypeRef()), context2.getSession(), false, null, 6, null)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)backingField.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getLATEINIT_NULLABLE_BACKING_FIELD(), null, (int)8, null);
        }
        if (declaration.getDelegate() != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)backingField.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getBACKING_FIELD_FOR_DELEGATED_PROPERTY(), null, (int)8, null);
        }
        if (declaration.getDelegate() == null && this.isExplicit(declaration.getGetter())) {
            FirPropertyAccessor firPropertyAccessor = declaration.getGetter();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firPropertyAccessor != null ? firPropertyAccessor.getSource() : null)), (KtDiagnosticFactory0)FirErrors.INSTANCE.getPROPERTY_WITH_EXPLICIT_FIELD_AND_ACCESSORS(), null, (int)8, null);
        }
        if (Intrinsics.areEqual((Object)FirTypeUtilsKt.getConeType(backingField.getReturnTypeRef()), (Object)FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)backingField.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_BACKING_FIELD(), null, (int)8, null);
        } else if (!TypeUtilsKt.isSubtypeOf(backingField, declaration, typeCheckerContext)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINCONSISTENT_BACKING_FIELD_TYPE(), null, (int)8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExplicit(FirPropertyAccessor $this$isExplicit) {
        if ($this$isExplicit == null) return false;
        KtSourceElement ktSourceElement = $this$isExplicit.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) return false;
        return true;
    }
}

